/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.util.CardUtil;

class ImmardTheStormcleaverEffect
extends OneShotEffect {
    private final ReflexiveTriggeredAbility ability = ImmardTheStormcleaverEffect.makeAbility();

    ImmardTheStormcleaverEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a charge counter on it or remove one from it. When you remove a counter this way, " + CardUtil.getTextWithFirstCharLowerCase((String)this.ability.getRule());
    }

    private ImmardTheStormcleaverEffect(ImmardTheStormcleaverEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImmardTheStormcleaverEffect copy() {
        return new ImmardTheStormcleaverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        if (!permanent.getCounters(game).containsKey(CounterType.CHARGE) || player.chooseUse(this.outcome, "Add or remove a charge counter?", null, "Add", "Remove", source, game)) {
            permanent.addCounters(CounterType.CHARGE.createInstance(), source, game);
        } else {
            permanent.removeCounters(CounterType.CHARGE.createInstance(), source, game);
            game.fireReflexiveTriggeredAbility(this.ability, source);
        }
        return true;
    }

    private static ReflexiveTriggeredAbility makeAbility() {
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(4), false);
        ability.addTarget((Target)new TargetAnyTarget());
        Mode mode = new Mode((Effect)new GainAbilitySourceEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn).setText("{this} gains lifelink"));
        mode.addEffect((Effect)new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn).setText("and indestructible until end of turn"));
        ability.addMode(mode);
        return ability;
    }
}

