/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.Effect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetControlledPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ImpelledGiantCost
extends CostImpl {
    TargetControlledPermanent target;

    public ImpelledGiantCost(TargetControlledPermanent target) {
        this.target = target;
        this.text = "Tap an untapped red creature you control other than {this}";
    }

    private ImpelledGiantCost(ImpelledGiantCost cost) {
        super((CostImpl)cost);
        this.target = cost.target.copy();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.target.choose(Outcome.Tap, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : this.target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) {
                    return false;
                }
                this.paid |= permanent.tap(source, game);
                for (Effect effect : ability.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                }
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    public ImpelledGiantCost copy() {
        return new ImpelledGiantCost(this);
    }
}

