/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class ImpulsiveManeuversEffect
extends PreventionEffectImpl {
    private boolean wonFlip;

    public ImpulsiveManeuversEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "flip a coin. If you win the flip, the next time that creature would deal combat damage this turn, it deals double that damage instead. If you lose the flip, the next time that creature would deal combat damage this turn, prevent that damage";
    }

    private ImpulsiveManeuversEffect(ImpulsiveManeuversEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.wonFlip = game.getPlayer(source.getControllerId()).flipCoin(source, game, true);
    }

    public ImpulsiveManeuversEffect copy() {
        return new ImpulsiveManeuversEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            game.informPlayers("Couldn't find source of damage");
            return false;
        }
        return event.getSourceId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent;
        MageObject object = game.getObject(event.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && object != null && super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0 && (damageEvent = (DamageEvent)event).isCombatDamage()) {
            if (this.wonFlip) {
                event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
                this.discard();
            } else {
                this.preventDamageAction(event, source, game);
                this.discard();
                return true;
            }
        }
        return false;
    }
}

