/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class InTheEyeOfChaosEffect
extends OneShotEffect {
    InTheEyeOfChaosEffect() {
        super(Outcome.Detriment);
        this.staticText = "counter it unless that player pays {X}, where X is its mana value";
    }

    private InTheEyeOfChaosEffect(InTheEyeOfChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public InTheEyeOfChaosEffect copy() {
        return new InTheEyeOfChaosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null && (player = game.getPlayer(spell.getControllerId())) != null) {
            ManaCost cost = ManaUtil.createManaCost((int)spell.getManaValue(), (boolean)true);
            if (!cost.pay(source, game, source, player.getId(), false)) {
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

