/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InameAsOneEffect
extends OneShotEffect {
    InameAsOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile it. If you do, return target Spirit permanent card from your graveyard to the battlefield";
    }

    private InameAsOneEffect(InameAsOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public InameAsOneEffect copy() {
        return new InameAsOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        Card targetCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && sourceObject != null && targetCard != null) {
            if (controller.chooseUse(this.outcome, "Exile " + sourceObject.getLogName() + " to return Spirit card?", source, game)) {
                ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetCard.getId(), targetCard.getZoneChangeCounter(game)));
                new ExileSourceEffect().apply(game, source);
                return effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

