/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.CollectEvidenceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllControlledTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class IncineratorOfTheGuiltyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("creature and planeswalker");

    IncineratorOfTheGuiltyEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may collect evidence X. When you do, {this} deals X damage to each creature and planeswalker that player controls.";
    }

    private IncineratorOfTheGuiltyEffect(IncineratorOfTheGuiltyEffect effect) {
        super((OneShotEffect)effect);
    }

    public IncineratorOfTheGuiltyEffect copy() {
        return new IncineratorOfTheGuiltyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.chooseUse(this.outcome, "Collect evidence X?", source, game)) {
            return false;
        }
        int xValue = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (collect evidence)", game, source, false);
        CollectEvidenceCost cost = new CollectEvidenceCost(xValue);
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageAllControlledTargetEffect(xValue, filter).setTargetPointer(this.getTargetPointer().copy()), false);
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

