/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InducedAmnesiaExileEffect
extends OneShotEffect {
    InducedAmnesiaExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "target player exiles all cards from their hand face down, then draws that many cards";
    }

    private InducedAmnesiaExileEffect(InducedAmnesiaExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public InducedAmnesiaExileEffect copy() {
        return new InducedAmnesiaExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        int numberOfCards = targetPlayer.getHand().size();
        if (numberOfCards < 1) {
            return false;
        }
        MageObject mageObject = game.getObject(source.getSourceId());
        if (mageObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)targetPlayer.getHand());
        targetPlayer.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (UUID)mageObject.getId(), (int)game.getState().getZoneChangeCounter(mageObject.getId())), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.getCards(game).stream().filter(card -> game.getState().getZone(card.getId()) == Zone.EXILED).forEach(card -> card.setFaceDown(true, game));
        targetPlayer.drawCards(numberOfCards, source, game);
        return true;
    }
}

