/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class IndustrialAdvancementEffect
extends OneShotEffect {
    IndustrialAdvancementEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice a creature. If you do, look at the top X cards of your library, where X is that creature's mana value. You may put a creature card from among them onto the battlefield. Put the rest on the bottom of your library in a random order";
    }

    private IndustrialAdvancementEffect(IndustrialAdvancementEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndustrialAdvancementEffect copy() {
        return new IndustrialAdvancementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, permanent.getManaValue()));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(Outcome.PutCreatureInPlay, (Cards)cards, (TargetCard)targetCard, source, game);
        player.moveCards(game.getCard(targetCard.getFirstTarget()), Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

