/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.List;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.RandomUtil;

class InfectiousRageReattachEffect
extends OneShotEffect {
    InfectiousRageReattachEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "choose a creature at random {this} can enchant. Return this card to the battlefield attached to that creature.";
    }

    private InfectiousRageReattachEffect(InfectiousRageReattachEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfectiousRageReattachEffect copy() {
        return new InfectiousRageReattachEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card auraCard = game.getCard(source.getSourceId());
        if (controller == null || auraCard == null) {
            return false;
        }
        if (source.getStackMomentSourceZCC() != auraCard.getZoneChangeCounter(game)) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)auraCard));
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
        if (permanents.isEmpty()) {
            game.informPlayers("No valid creatures for " + auraCard.getLogName() + "to enchant.");
            return false;
        }
        Permanent creature = (Permanent)RandomUtil.randomFromCollection((Collection)permanents);
        if (creature == null) {
            return false;
        }
        game.getState().setValue("attachTo:" + auraCard.getId(), (Object)creature);
        controller.moveCards(auraCard, Zone.BATTLEFIELD, source, game);
        return creature.addAttachment(auraCard.getId(), source, game);
    }
}

