/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.MinionToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class InfernalGenesisEffect
extends OneShotEffect {
    private static final Token token = new MinionToken();

    InfernalGenesisEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "that player mills a card. Then they create X 1/1 black Minion creature tokens, where X is the milled card's mana value.";
    }

    private InfernalGenesisEffect(InfernalGenesisEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int totalCMC = player.millCards(1, source, game).getCards(game).stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        if (totalCMC > 0) {
            token.putOntoBattlefield(totalCMC, game, source, player.getId());
        }
        return true;
    }

    public InfernalGenesisEffect copy() {
        return new InfernalGenesisEffect(this);
    }
}

