/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class InfernalHarvestAdditionalCost
extends VariableCostImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.SWAMP);

    InfernalHarvestAdditionalCost() {
        super(VariableCostType.ADDITIONAL, "Swamps to return");
        this.text = "return " + this.xText + " Swamps you control to their owner's hand";
    }

    private InfernalHarvestAdditionalCost(InfernalHarvestAdditionalCost cost) {
        super((VariableCostImpl)cost);
    }

    public InfernalHarvestAdditionalCost copy() {
        return new InfernalHarvestAdditionalCost(this);
    }

    public int getMaxValue(Ability source, Game game) {
        return game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new InfernalHarvestCost(xValue);
    }

    private static final class InfernalHarvestCost
    extends CostImpl {
        private final int xValue;

        private InfernalHarvestCost(int xValue) {
            this.xValue = xValue;
            this.text = "return " + xValue + " Swamps you control to their owner's hand";
            this.addTarget((Target)new TargetControlledPermanent(xValue, xValue, filter, true));
        }

        private InfernalHarvestCost(InfernalHarvestCost cost) {
            super((CostImpl)cost);
            this.xValue = cost.xValue;
        }

        public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
            return game.getBattlefield().countAll((FilterPermanent)filter, controllerId, game) >= this.xValue;
        }

        public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
            if (!this.canPay(ability, source, controllerId, game)) {
                return false;
            }
            Player player = game.getPlayer(controllerId);
            if (player == null || !this.getTargets().choose(Outcome.ReturnToHand, controllerId, source.getSourceId(), source, game)) {
                return false;
            }
            this.paid = player.moveCards(this.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet()), Zone.HAND, ability, game);
            return this.paid;
        }

        public InfernalHarvestCost copy() {
            return new InfernalHarvestCost(this);
        }
    }
}

