/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class InfernalKirinEffect
extends OneShotEffect {
    InfernalKirinEffect() {
        super(Outcome.Detriment);
        this.staticText = "target player reveals their hand and discards all cards with that spell's mana value";
    }

    private InfernalKirinEffect(InfernalKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalKirinEffect copy() {
        return new InfernalKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        int cmc = spell.getManaValue();
        Player targetPlayer = null;
        for (Target target : source.getTargets()) {
            if (!(target instanceof TargetPlayer)) continue;
            targetPlayer = game.getPlayer(target.getFirstTarget());
        }
        if (targetPlayer == null) {
            return false;
        }
        if (targetPlayer.getHand().isEmpty()) {
            return true;
        }
        targetPlayer.revealCards(source, targetPlayer.getHand(), game);
        Cards cards = targetPlayer.getHand().copy();
        cards.removeIf(uuid -> game.getCard(uuid).getManaValue() != cmc);
        targetPlayer.discard(cards, false, source, game);
        return true;
    }
}

