/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;

class InfestedThrinaxTriggeredAbility
extends DelayedTriggeredAbility {
    InfestedThrinaxTriggeredAbility() {
        super((Effect)new CreateTokenEffect((Token)new SaprolingToken(), (DynamicValue)SavedDamageValue.MUCH), Duration.EndOfTurn, false, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private InfestedThrinaxTriggeredAbility(InfestedThrinaxTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public InfestedThrinaxTriggeredAbility copy() {
        return new InfestedThrinaxTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || zEvent.getTarget() instanceof PermanentToken || !zEvent.getTarget().isCreature(game) || !zEvent.getTarget().isControlledBy(this.getControllerId())) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)zEvent.getTarget().getPower().getValue());
        return true;
    }

    public String getRule() {
        return "Whenever a nontoken creature you control dies, create a number of 1/1 green Saproling creature tokens equal to that creature's power.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

