/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InfiniteAuthorityEffect
extends OneShotEffect {
    InfiniteAuthorityEffect() {
        super(Outcome.Detriment);
        this.staticText = "destroy the other creature at end of combat. At the beginning of the next end step, if that creature was destroyed this way, put a +1/+1 counter on the first creature";
    }

    private InfiniteAuthorityEffect(InfiniteAuthorityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Permanent enchantedCreature;
        Permanent aura = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (aura != null && (enchantedCreature = game.getPermanentOrLKIBattlefield(aura.getAttachedTo())) != null && (permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            if (permanent.destroy(source, game, false)) {
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
                ((Effect)delayedAbility.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(enchantedCreature, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }

    public InfiniteAuthorityEffect copy() {
        return new InfiniteAuthorityEffect(this);
    }
}

