/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InfiniteObliterationEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    InfiniteObliterationEffect() {
        super(true, "target opponent's", "any number of cards with that name");
        this.staticText = "Choose a creature card name. " + CardUtil.getTextWithFirstCharUpperCase((String)this.staticText);
    }

    private InfiniteObliterationEffect(InfiniteObliterationEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return true;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.CREATURE_NAME.getChoice(controller, game, source, false);
        super.applySearchAndExile(game, source, cardName, player.getId());
        return true;
    }

    public InfiniteObliterationEffect copy() {
        return new InfiniteObliterationEffect(this);
    }
}

