/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class InjuryEffect
extends OneShotEffect {
    InjuryEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to target creature and 2 damage to target player or planeswalker";
    }

    private InjuryEffect(InjuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Player player = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (permanent != null) {
            permanent.damage(2, source.getSourceId(), source, game, false, true);
        }
        if (player != null) {
            player.damage(2, source.getSourceId(), source, game);
        }
        return true;
    }

    public InjuryEffect copy() {
        return new InjuryEffect(this);
    }
}

