/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class InquisitionEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    public InquisitionEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player reveals their hand. {this} deals damage to that player equal to the number of white cards in their hand";
    }

    private InquisitionEffect(InquisitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null && (targetPlayer = game.getPlayer(source.getFirstTarget())) != null) {
            targetPlayer.revealCards("hand of " + targetPlayer.getName(), targetPlayer.getHand(), game);
            int cardsFound = 0;
            for (Card card : targetPlayer.getHand().getCards(game)) {
                if (!filter.match(card, game)) continue;
                ++cardsFound;
            }
            if (cardsFound > 0) {
                targetPlayer.damage(cardsFound, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public InquisitionEffect copy() {
        return new InquisitionEffect(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

