/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class InscribedTabletEffect
extends OneShotEffect {
    InscribedTabletEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top five cards of your library. Put a land card from among them into your hand and the rest on the bottom of your library in a random order. If you didn't put a card into your hand this way, draw a card.";
    }

    private InscribedTabletEffect(InscribedTabletEffect effect) {
        super((OneShotEffect)effect);
    }

    public InscribedTabletEffect copy() {
        return new InscribedTabletEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        controller.revealCards(source, (Cards)cards, game);
        boolean landToHand = false;
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_LAND, controller.getId(), source, game) > 0) {
            TargetCard target = new TargetCard(Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_LAND);
            controller.chooseTarget(this.outcome, (Cards)cards, target, source, game);
            Card land = game.getCard(target.getFirstTarget());
            if (land != null) {
                cards.remove(land);
                landToHand = controller.moveCardToHandWithInfo(land, source, game, true);
            }
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        if (!landToHand) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

