/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class InsidiousDreamsEffect
extends OneShotEffect {
    InsidiousDreamsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for X cards, then shuffle and put those cards on top in any order";
    }

    private InsidiousDreamsEffect(InsidiousDreamsEffect effect) {
        super((OneShotEffect)effect);
    }

    public InsidiousDreamsEffect copy() {
        return new InsidiousDreamsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int minTargets = Math.min(controller.getLibrary().size(), GetXValue.instance.calculate(game, source, (Effect)this));
        TargetCardInLibrary target = new TargetCardInLibrary(minTargets, GetXValue.instance.calculate(game, source, (Effect)this), StaticFilters.FILTER_CARD_CARDS);
        controller.searchLibrary(target, source, game);
        CardsImpl chosen = new CardsImpl((Collection)target.getTargets());
        controller.shuffleLibrary(source, game);
        controller.putCardsOnTopOfLibrary((Cards)chosen, game, source, true);
        return true;
    }
}

