/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class InspirationFromBeyondEffect
extends OneShotEffect {
    InspirationFromBeyondEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return an instant or sorcery card from your graveyard to your hand";
    }

    private InspirationFromBeyondEffect(InspirationFromBeyondEffect effect) {
        super((OneShotEffect)effect);
    }

    public InspirationFromBeyondEffect copy() {
        return new InspirationFromBeyondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game));
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInGraveyard target = new TargetCardInGraveyard();
                target.withNotTarget(true);
                player.choose(Outcome.ReturnToHand, (Cards)cards, (TargetCard)target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

