/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class InspiredUltimatumEffect
extends OneShotEffect {
    InspiredUltimatumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player gains 5 life, {this} deals 5 damage to any target, then you draw five cards.";
    }

    private InspiredUltimatumEffect(InspiredUltimatumEffect effect) {
        super((OneShotEffect)effect);
    }

    public InspiredUltimatumEffect copy() {
        return new InspiredUltimatumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        if (player != null) {
            player.gainLife(5, game, source);
        }
        game.damagePlayerOrPermanent(((Target)source.getTargets().get(1)).getFirstTarget(), 5, source.getSourceId(), source, game, false, true);
        player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(5, source, game);
        }
        return true;
    }
}

