/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class InstrumentOfTheBardsEffect
extends OneShotEffect {
    InstrumentOfTheBardsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for a creature card with mana value equal to the number of harmony counters on {this}, reveal it, and put it into your hand. If that card is legendary, create a Treasure token. Then shuffle";
    }

    private InstrumentOfTheBardsEffect(InstrumentOfTheBardsEffect effect) {
        super((OneShotEffect)effect);
    }

    public InstrumentOfTheBardsEffect copy() {
        return new InstrumentOfTheBardsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        int counters = permanent.getCounters(game).getCount(CounterType.HARMONY);
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + counters);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, counters));
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        if (controller.searchLibrary(target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.revealCards(permanent.getIdName(), (Cards)new CardsImpl(card), game);
            controller.moveCards(card, Zone.HAND, source, game);
            if (card.isLegendary(game)) {
                new TreasureToken().putOntoBattlefield(1, game, source, source.getControllerId());
            }
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

