/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class IntellectDevourerExileEffect
extends OneShotEffect {
    IntellectDevourerExileEffect() {
        super(Outcome.Exile);
        this.staticText = "each opponent exiles a card from their hand until {this} leaves the battlefield";
    }

    private IntellectDevourerExileEffect(IntellectDevourerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntellectDevourerExileEffect copy() {
        return new IntellectDevourerExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getState().getZone(source.getSourceId()) != Zone.BATTLEFIELD) {
            return false;
        }
        boolean applied = false;
        HashMap<UUID, CardsImpl> cardsToExile = new HashMap<UUID, CardsImpl>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            if (!opponent.getHand().isEmpty()) {
                TargetCardInHand target = new TargetCardInHand(1, new FilterCard());
                target.setRequired(true);
                if (!opponent.chooseTarget(Outcome.Exile, (Target)target, source, game)) continue;
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                cardsToExile.put(opponentId, cards);
                continue;
            }
            cardsToExile.put(opponentId, new CardsImpl());
        }
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            CardsImpl opponentCardsToExile = new CardsImpl();
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !cardsToExile.containsKey(opponentId) || ((Cards)cardsToExile.get(opponentId)).isEmpty()) continue;
            opponentCardsToExile.addAll((Collection)cardsToExile.get(opponentId));
            opponent.moveCardsToExile(opponentCardsToExile.getCards(game), source, game, false, exileZoneId, sourceObject.getIdName());
            Card thisCard = (Card)opponentCardsToExile.getCards(game).iterator().next();
            game.getState().setValue(thisCard.getId().toString() + game.getState().getZoneChangeCounter(thisCard.getId()), (Object)exileZoneId);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)thisCard, (boolean)false, (Duration)Duration.Custom, (boolean)true, (UUID)source.getControllerId(), null);
            applied = true;
        }
        return applied;
    }
}

