/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class IntercessorsArrestEffect
extends ContinuousRuleModifyingEffectImpl {
    IntercessorsArrestEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = ", or crew Vehicles. Its activated abilities can't be activated unless they're mana abilities";
    }

    private IntercessorsArrestEffect(IntercessorsArrestEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public IntercessorsArrestEffect copy() {
        return new IntercessorsArrestEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case CREW_VEHICLE: 
            case ACTIVATE_ABILITY: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        switch (event.getType()) {
            case CREW_VEHICLE: {
                return enchantment.isAttachedTo(event.getTargetId());
            }
            case ACTIVATE_ABILITY: {
                if (!enchantment.isAttachedTo(event.getSourceId())) break;
                Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
                return ability.isPresent() && ((Ability)ability.get()).isNonManaActivatedAbility();
            }
        }
        return false;
    }
}

