/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.SourceRemainsInZoneCondition;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class IntetTheDreamerAsThoughEffect
extends AsThoughEffectImpl {
    IntetTheDreamerAsThoughEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may play that card without paying its mana cost for as long as Intet remains on the battlefield.";
    }

    private IntetTheDreamerAsThoughEffect(IntetTheDreamerAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IntetTheDreamerAsThoughEffect copy() {
        return new IntetTheDreamerAsThoughEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (targetId == null) {
            this.discard();
            return false;
        }
        Card card = game.getCard(objectId);
        if (card == null) {
            this.discard();
            return false;
        }
        objectId = card.getMainCard().getId();
        if (objectId.equals(targetId) && affectedControllerId.equals(source.getControllerId())) {
            Card exiledCard = game.getCard(objectId);
            if (exiledCard == null) {
                this.discard();
                return false;
            }
            this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, game);
            if (!new SourceRemainsInZoneCondition(Zone.BATTLEFIELD).apply(game, source)) {
                this.discard();
                return false;
            }
            return true;
        }
        return false;
    }
}

