/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class IntoThePitEffect
extends AsThoughEffectImpl {
    IntoThePitEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "you may cast spells from the top of your library by sacrificing a nonland permanent in addition to paying their other costs";
    }

    private IntoThePitEffect(IntoThePitEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IntoThePitEffect copy() {
        return new IntoThePitEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null || !source.isControlledBy(affectedControllerId) || !cardToCheck.isOwnedBy(affectedControllerId)) {
            return false;
        }
        Player player = game.getPlayer(cardToCheck.getOwnerId());
        if (player == null) {
            return false;
        }
        Card topCard = player.getLibrary().getFromTop(game);
        if (topCard == null || !topCard.getId().equals(cardToCheck.getMainCard().getId()) || cardToCheck.isLand(game)) {
            return false;
        }
        CostsImpl newCosts = new CostsImpl();
        newCosts.add((Object)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND));
        newCosts.addAll((Collection)cardToCheck.getSpellAbility().getCosts());
        player.setCastSourceIdWithAlternateMana(cardToCheck.getId(), cardToCheck.getManaCost(), (Costs)newCosts, MageIdentifier.IntoThePitAlternateCast);
        return true;
    }
}

