/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Thopter00ColorlessToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class IntrudeOnTheMindEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards to put in the first pile");

    IntrudeOnTheMindEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top five cards of your library and separate them into two piles. An opponent chooses one of those piles. Put that pile into your hand and the other into your graveyard. Create a 0/0 colorless Thopter artifact creature token with flying, then put a +1/+1 counter on it for each card put into your graveyard this way.";
    }

    private IntrudeOnTheMindEffect(IntrudeOnTheMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntrudeOnTheMindEffect copy() {
        return new IntrudeOnTheMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl allCards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        Cards cards = allCards.copy();
        controller.revealCards(source, cards, game);
        TargetCard target = new TargetCard(0, cards.size(), Zone.LIBRARY, filter);
        ArrayList pile1 = new ArrayList();
        controller.choose(Outcome.Neutral, cards, target, source, game);
        target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).forEach(pile1::add);
        cards.removeIf(target.getTargets()::contains);
        ArrayList pile2 = new ArrayList();
        pile2.addAll(cards.getCards(game));
        Player opponent = IntrudeOnTheMindEffect.getOpponent(controller, game, source);
        if (opponent == null) {
            return false;
        }
        boolean choice = opponent.choosePile(this.outcome, "Choose a pile to put into hand.", pile1, pile2, game);
        Zone pile1Zone = choice ? Zone.HAND : Zone.GRAVEYARD;
        Zone pile2Zone = choice ? Zone.GRAVEYARD : Zone.HAND;
        game.informPlayers("Pile 1, going to " + pile1Zone + ": " + (pile1.isEmpty() ? " (none)" : pile1.stream().map(MageObject::getName).collect(Collectors.joining(", "))));
        cards.clear();
        cards.addAllCards(pile1);
        controller.moveCards(cards, pile1Zone, source, game);
        game.informPlayers("Pile 2, going to " + pile2Zone + ": " + (pile2.isEmpty() ? " (none)" : pile2.stream().map(MageObject::getName).collect(Collectors.joining(", "))));
        cards.clear();
        cards.addAllCards(pile2);
        controller.moveCards(cards, pile2Zone, source, game);
        Thopter00ColorlessToken token = new Thopter00ColorlessToken();
        token.putOntoBattlefield(1, game, source);
        allCards.retainZone(Zone.GRAVEYARD, game);
        int count = allCards.size();
        if (count <= 0) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(count), source.getControllerId(), source, game);
        }
        return true;
    }

    private static Player getOpponent(Player controller, Game game, Ability source) {
        Player opponent;
        Set opponents = game.getOpponents(source.getControllerId());
        if (opponents.isEmpty()) {
            return null;
        }
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            TargetOpponent targetOpponent = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Neutral, (Target)targetOpponent, source, game);
            opponent = game.getPlayer(targetOpponent.getFirstTarget());
            if (opponent == null) {
                return null;
            }
            game.informPlayers(controller.getLogName() + " chose " + opponent.getLogName() + " to choose the piles");
        }
        return opponent;
    }
}

