/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class IntuitionEffect
extends SearchEffect {
    public IntuitionEffect() {
        super(new TargetCardInLibrary(3, new FilterCard()), Outcome.Benefit);
        this.staticText = "Search your library for three cards and reveal them. Target opponent chooses one. Put that card into your hand and the rest into your graveyard. Then shuffle";
    }

    private IntuitionEffect(IntuitionEffect effect) {
        super((SearchEffect)effect);
    }

    public IntuitionEffect copy() {
        return new IntuitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        if (controller.getLibrary().size() >= 3 && controller.searchLibrary(this.target, source, game)) {
            if (this.target.getTargets().size() == 3) {
                CardsImpl cards = new CardsImpl();
                for (UUID cardId : this.target.getTargets()) {
                    Card card = controller.getLibrary().getCard(cardId, game);
                    if (card == null) continue;
                    cards.add(card);
                }
                controller.revealCards("Reveal", (Cards)cards, game);
                TargetCard targetCard = new TargetCard(Zone.LIBRARY, new FilterCard());
                while (!opponent.choose(Outcome.Neutral, (Cards)cards, targetCard, source, game)) {
                    if (opponent.canRespond()) continue;
                    return false;
                }
                Card card = cards.get(targetCard.getFirstTarget(), game);
                if (card != null) {
                    cards.remove(card);
                    controller.moveCards(card, Zone.HAND, source, game);
                }
                controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }

    public List<UUID> getTargets() {
        return this.target.getTargets();
    }
}

