/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.i.InvasionOfGobakhanCastEffect;
import mage.cards.i.InvasionOfGobakhanCostEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class InvasionOfGobakhanEffect
extends OneShotEffect {
    InvasionOfGobakhanEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at target opponent's hand. You may exile a nonland card from it. For as long as that card remains exiled, its owner may play it. A spell cast this way costs {2} more to cast";
    }

    private InvasionOfGobakhanEffect(InvasionOfGobakhanEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfGobakhanEffect copy() {
        return new InvasionOfGobakhanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null || opponent.getHand().isEmpty()) {
            return false;
        }
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        controller.choose(this.outcome, opponent.getHand(), target, source, game);
        Card card = opponent.getHand().get(target.getFirstTarget(), game);
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new InvasionOfGobakhanCastEffect(card, game), source);
        game.addEffect((ContinuousEffect)new InvasionOfGobakhanCostEffect(card, game), source);
        return true;
    }
}

