/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class InvasionPlansEffect
extends ContinuousRuleModifyingEffectImpl {
    InvasionPlansEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false, false);
        this.staticText = "The attacking player chooses how each creature blocks each combat";
    }

    private InvasionPlansEffect(InvasionPlansEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public InvasionPlansEffect copy() {
        return new InvasionPlansEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARING_BLOCKERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player blockController = game.getPlayer(game.getCombat().getAttackingPlayerId());
        if (blockController != null && !blockController.isComputer()) {
            game.getCombat().selectBlockers(blockController, source, game);
            return event.getPlayerId().equals(game.getCombat().getAttackingPlayerId());
        }
        return false;
    }
}

