/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

class InventoryManagementEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("Aura or Equipment you control");

    InventoryManagementEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each Aura and Equipment you control, you may attach it to a creature you control";
    }

    private InventoryManagementEffect(InventoryManagementEffect effect) {
        super((OneShotEffect)effect);
    }

    public InventoryManagementEffect copy() {
        return new InventoryManagementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains(filter, source, game, 1) || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        target.withChooseHint("to attach to a creature you control");
        player.choose(this.outcome, (Target)target, source, game);
        List permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            TargetControlledCreaturePermanent targetCreature = new TargetControlledCreaturePermanent(0, 1);
            targetCreature.withNotTarget(true);
            targetCreature.withChooseHint("to attach " + permanent.getLogName() + " to");
            Optional.ofNullable(targetCreature).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(p -> p.addAttachment(permanent.getId(), source, game));
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

