/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class InvertPolarityGainControlTargetEffect
extends OneShotEffect {
    InvertPolarityGainControlTargetEffect() {
        super(Outcome.GainControl);
        this.staticText = "gain control of that spell and you may choose new targets for it";
    }

    private InvertPolarityGainControlTargetEffect(InvertPolarityGainControlTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvertPolarityGainControlTargetEffect copy() {
        return new InvertPolarityGainControlTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (controller != null && spell != null) {
            spell.setControllerId(controller.getId());
            spell.chooseNewTargets(game, controller.getId(), false, false, null);
            return true;
        }
        return false;
    }
}

