/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetControlledPermanent;

class InvokeDespairEffect
extends OneShotEffect {
    private static final FilterControlledEnchantmentPermanent enchantmentFilter = new FilterControlledEnchantmentPermanent();

    public InvokeDespairEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target opponent sacrifices a creature. If they can't, they lose 2 life and you draw a card. Then repeat this process for an enchantment and a planeswalker";
    }

    private InvokeDespairEffect(InvokeDespairEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvokeDespairEffect copy() {
        return new InvokeDespairEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent == null || controller == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        opponent.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        boolean sacrificed = false;
        if (permanent != null) {
            sacrificed = permanent.sacrifice(source, game);
        }
        if (!sacrificed) {
            opponent.loseLife(2, game, source, false);
            controller.drawCards(1, source, game);
        }
        target = new TargetControlledPermanent((FilterControlledPermanent)enchantmentFilter);
        target.withNotTarget(true);
        opponent.choose(this.outcome, (Target)target, source, game);
        permanent = game.getPermanent(target.getFirstTarget());
        sacrificed = false;
        if (permanent != null) {
            sacrificed = permanent.sacrifice(source, game);
        }
        if (!sacrificed) {
            opponent.loseLife(2, game, source, false);
            controller.drawCards(1, source, game);
        }
        target = new TargetControlledPermanent(StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER);
        target.withNotTarget(true);
        opponent.choose(this.outcome, (Target)target, source, game);
        permanent = game.getPermanent(target.getFirstTarget());
        sacrificed = false;
        if (permanent != null) {
            sacrificed = permanent.sacrifice(source, game);
        }
        if (!sacrificed) {
            opponent.loseLife(2, game, source, false);
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

