/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.cards.i.IrencragFeatCantCastEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.watchers.common.CastSpellLastTurnWatcher;

class IrencragFeatEffect
extends OneShotEffect {
    IrencragFeatEffect() {
        super(Outcome.Benefit);
        this.staticText = "Add seven {R}. You can cast only one more spell this turn.";
    }

    private IrencragFeatEffect(IrencragFeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public IrencragFeatEffect copy() {
        return new IrencragFeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new BasicManaEffect(Mana.RedMana((int)7)).apply(game, source);
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        int start = watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId());
        game.addEffect((ContinuousEffect)new IrencragFeatCantCastEffect(start), source);
        return true;
    }
}

