/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class IronMaidenEffect
extends OneShotEffect {
    private IronMaidenEffect(IronMaidenEffect effect) {
        super((OneShotEffect)effect);
    }

    public IronMaidenEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is the number of cards in their hand minus 4";
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (amount = player.getHand().size() - 4) > 0) {
            player.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public IronMaidenEffect copy() {
        return new IronMaidenEffect(this);
    }
}

