/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class IronManTitanOfInnovationEffect
extends OneShotEffect {
    IronManTitanOfInnovationEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may sacrifice a noncreature artifact. If you do, search your library for an artifact card with mana value equal to 1 plus the sacrificed artifact's mana value, put it onto the battlefield tapped, then shuffle";
    }

    private IronManTitanOfInnovationEffect(IronManTitanOfInnovationEffect effect) {
        super((OneShotEffect)effect);
    }

    public IronManTitanOfInnovationEffect copy() {
        return new IronManTitanOfInnovationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_ARTIFACT_NON_CREATURE);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int mv = permanent.getManaValue() + 1;
        FilterArtifactCard filter = new FilterArtifactCard("artifact card with mana value " + mv);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, mv));
        TargetCardInLibrary targetCardInLibrary = new TargetCardInLibrary((FilterCard)filter);
        player.searchLibrary(targetCardInLibrary, source, game);
        Card card = player.getLibrary().getCard(targetCardInLibrary.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

