/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.players.Player;

class IronMastiffEffect
extends RollDieWithResultTableEffect {
    IronMastiffEffect() {
        super(20, "roll a d20 for each player being attacked and ignore all but the highest roll");
        this.addTableEntry(1, 9, new Effect[]{new DamageControllerEffect((DynamicValue)SourcePermanentPowerValue.NOT_NEGATIVE).setText("{this} deals damage equal to its power to you")});
        this.addTableEntry(10, 19, new Effect[]{new DamageTargetEffect((DynamicValue)SourcePermanentPowerValue.NOT_NEGATIVE).setText("{this} deals damage equal to its power to defending player")});
        this.addTableEntry(20, 20, new Effect[]{new DamagePlayersEffect(Outcome.Damage, (DynamicValue)SourcePermanentPowerValue.NOT_NEGATIVE, TargetController.OPPONENT).setText("{this} deals damage equal to its power to each opponent")});
    }

    private IronMastiffEffect(IronMastiffEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public IronMastiffEffect copy() {
        return new IronMastiffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int toRoll = game.getCombat().getGroups().stream().map(CombatGroup::getDefenderId).filter(Objects::nonNull).distinct().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(x -> 1).sum();
        if (toRoll < 1) {
            return false;
        }
        int result = (Integer)player.rollDice(this.outcome, source, game, this.sides, toRoll, toRoll - 1).get(0);
        this.applyResult(result, game, source);
        return true;
    }
}

