/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class IronscaleHydraEffect
extends PreventionEffectImpl {
    private static final Effect effect = new AddCountersSourceEffect(CounterType.P1P1.createInstance());

    IronscaleHydraEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, true, false);
        this.staticText = "If a creature would deal combat damage to {this}, prevent that damage and put a +1/+1 counter on {this}.";
    }

    private IronscaleHydraEffect(IronscaleHydraEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public IronscaleHydraEffect copy() {
        return new IronscaleHydraEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game) || !event.getTargetId().equals(source.getSourceId())) {
            return false;
        }
        Permanent damageSource = game.getPermanent(event.getSourceId());
        return damageSource != null && damageSource.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        effect.apply(game, source);
        return super.replaceEvent(event, source, game);
    }
}

