/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.LeaveBattlefieldExileTargetReplacementEffect;
import mage.cards.i.IsarethTheAwakenerEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class IsarethTheAwakenerCreateReflexiveTriggerEffect
extends OneShotEffect {
    private static final String rule = "return target creature card with mana value X from your graveyard to the battlefield with a corpse counter on it. If that creature would leave the battlefield, exile it instead of putting it anywhere else.";

    IsarethTheAwakenerCreateReflexiveTriggerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. When you do, return target creature card with mana value X from your graveyard to the battlefield with a corpse counter on it. If that creature would leave the battlefield, exile it instead of putting it anywhere else.";
    }

    private IsarethTheAwakenerCreateReflexiveTriggerEffect(IsarethTheAwakenerCreateReflexiveTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public IsarethTheAwakenerCreateReflexiveTriggerEffect copy() {
        return new IsarethTheAwakenerCreateReflexiveTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (player == null || !player.chooseUse(Outcome.BoostCreature, "Pay " + cost.getText() + "?", source, game)) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to return due mana value)", game, source, true);
        cost.add((Object)new GenericManaCost(costX));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new IsarethTheAwakenerEffect(), false, rule);
        ability.addEffect((Effect)new LeaveBattlefieldExileTargetReplacementEffect("that creature"));
        ability.addTarget((Target)new TargetCardInYourGraveyard(IsarethTheAwakenerCreateReflexiveTriggerEffect.makeFilter(costX)));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    private static FilterCard makeFilter(int xValue) {
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + xValue + " or less from your graveyard");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        return filter;
    }
}

