/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class IsengardUnleashedTripleDamageEffect
extends ReplacementEffectImpl {
    IsengardUnleashedTripleDamageEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "If a source you control would deal damage this turn to an opponent or a permanent an opponent controls, it deals triple that damage instead.";
    }

    private IsengardUnleashedTripleDamageEffect(IsengardUnleashedTripleDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public IsengardUnleashedTripleDamageEffect copy() {
        return new IsengardUnleashedTripleDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER || event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getControllerId(event.getSourceId()).equals(source.getControllerId())) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER) {
            return game.isOpponent(controller, event.getTargetId());
        }
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            return permanent != null && game.isOpponent(controller, permanent.getControllerId());
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)3));
        return false;
    }
}

