/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DraftFromSpellbookEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.keyword.ReachAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.ExpansionSet;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.target.common.TargetCardInYourGraveyard;

public final class IshkanahBroodmother
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent(SubType.SPIDER, "Spiders");
    private static final List<String> spellbook = new ArrayList<String>(Arrays.asList("Arachnoform", "Brood Weaver", "Drider", "Glowstone Recluse", "Gnottvold Recluse", "Hatchery Spider", "Mammoth Spider", "Netcaster Spider", "Prey Upon", "Sentinel Spider", "Snarespinner", "Spider Spawning", "Spidery Grasp", "Sporecap Spider", "Twin-Silk Spider"));

    public IshkanahBroodmother(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{G}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.SPIDER);
        this.power = new MageInt(3);
        this.toughness = new MageInt(5);
        this.addAbility((Ability)ReachAbility.getInstance());
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostControlledEffect(1, 2, Duration.WhileOnBattlefield, (FilterPermanent)filter, true)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DraftFromSpellbookEffect(spellbook), (Cost)new ManaCostsImpl("{1}{B/G}"));
        ability.addCost((Cost)new ExileFromGraveCost(new TargetCardInYourGraveyard(2, StaticFilters.FILTER_CARD_CARDS)));
        this.addAbility((Ability)ability);
    }

    private IshkanahBroodmother(IshkanahBroodmother card) {
        super((CardImpl)card);
    }

    public IshkanahBroodmother copy() {
        return new IshkanahBroodmother(this);
    }

    static {
        spellbook.removeIf(card -> ExpansionSet.MUTATE_CARD_NAMES.contains(card));
    }
}

