/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class IsildursFatefulStrikeEffect
extends OneShotEffect {
    IsildursFatefulStrikeEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target creature. If its controller has more than four cards in hand, they exile cards from their hand equal to the difference";
    }

    private IsildursFatefulStrikeEffect(IsildursFatefulStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public IsildursFatefulStrikeEffect copy() {
        return new IsildursFatefulStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null || player.getHand().size() <= 4) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand(player.getHand().size() - 4, StaticFilters.FILTER_CARD);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.EXILED, source, game);
        return true;
    }
}

