/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.combat.CantAttackYouAllEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IslandwalkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class IslandSanctuaryEffect
extends ReplacementEffectImpl {
    private static final FilterCreaturePermanent notFlyingorIslandwalkCreatures = new FilterCreaturePermanent("except by creatures with flying and/or islandwalk");

    IslandSanctuaryEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card during your draw step, instead you may skip that draw. If you do, until your next turn, you can't be attacked except by creatures with flying and/or islandwalk";
    }

    private IslandSanctuaryEffect(IslandSanctuaryEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller != null && controller.chooseUse(this.outcome, "Skip draw card? (If you do, until your next turn, you can't be attacked except by creatures with flying and/or islandwalk)", source, game)) {
            game.informPlayers(controller.getLogName() + " skips their draw card action. Until their next turn, they can't be attacked except by creatures with flying and/or islandwalk");
            game.addEffect((ContinuousEffect)new CantAttackYouAllEffect(Duration.UntilYourNextTurn, notFlyingorIslandwalkCreatures), source);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && game.getTurnStepType() == PhaseStep.DRAW && game.getActivePlayerId().equals(source.getControllerId());
    }

    public IslandSanctuaryEffect copy() {
        return new IslandSanctuaryEffect(this);
    }

    static {
        notFlyingorIslandwalkCreatures.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
        notFlyingorIslandwalkCreatures.add(Predicates.not((Predicate)new AbilityPredicate(IslandwalkAbility.class)));
    }
}

