/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import org.apache.log4j.Logger;

class IsochronScepterCopyEffect
extends OneShotEffect {
    IsochronScepterCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "You may copy the exiled card. If you do, you may cast the copy without paying its mana cost";
    }

    private IsochronScepterCopyEffect(IsochronScepterCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public IsochronScepterCopyEffect copy() {
        return new IsochronScepterCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card copiedCard;
            Card imprintedInstant;
            Permanent scepter = game.getPermanentOrLKIBattlefield(source.getSourceId());
            if (scepter != null && scepter.getImprinted() != null && !scepter.getImprinted().isEmpty() && (imprintedInstant = game.getCard((UUID)scepter.getImprinted().get(0))) != null && game.getState().getZone(imprintedInstant.getId()) == Zone.EXILED && controller.chooseUse(this.outcome, "Create a copy of " + imprintedInstant.getName() + '?', source, game) && (copiedCard = game.copyCard(imprintedInstant, source, source.getControllerId())) != null && controller.chooseUse(this.outcome, "Cast the copied card without paying mana cost?", source, game)) {
                if (copiedCard.getSpellAbility() != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
                } else {
                    Logger.getLogger(IsochronScepterCopyEffect.class).error((Object)("Isochron Scepter: spell ability == null " + copiedCard.getName()));
                }
            }
            return true;
        }
        return false;
    }
}

