/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IsolatedWatchtowerEffect
extends OneShotEffect {
    IsolatedWatchtowerEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 1, then you may reveal the top card of your library. If a basic land card is revealed this way, put it onto the battlefield tapped";
    }

    private IsolatedWatchtowerEffect(IsolatedWatchtowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public IsolatedWatchtowerEffect copy() {
        return new IsolatedWatchtowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(1, source, game);
        if (!player.chooseUse(this.outcome, "Reveal the top card of your library?", source, game)) {
            return true;
        }
        Card card = player.getLibrary().getFromTop(game);
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isBasic(game) && card.isLand(game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        }
        return true;
    }
}

