/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class JaceWielderOfMysteriesEffect
extends OneShotEffect {
    JaceWielderOfMysteriesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw seven cards. Then if your library has no cards in it, you win the game.";
    }

    private JaceWielderOfMysteriesEffect(JaceWielderOfMysteriesEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaceWielderOfMysteriesEffect copy() {
        return new JaceWielderOfMysteriesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(7, source, game);
        if (!player.getLibrary().hasCards()) {
            player.won(game);
        }
        return true;
    }
}

