/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.j.JacobHaukenInspectorLookEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class JacobHaukenInspectorExileEffect
extends OneShotEffect {
    JacobHaukenInspectorExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then exile a card from your hand face down. You may look at that card for as long as it remains exiled";
    }

    private JacobHaukenInspectorExileEffect(JacobHaukenInspectorExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public JacobHaukenInspectorExileEffect copy() {
        return new JacobHaukenInspectorExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        if (!controller.getHand().isEmpty()) {
            TargetCardInHand target = new TargetCardInHand().withChooseHint("to exile");
            controller.chooseTarget(this.outcome, controller.getHand(), (TargetCard)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                MageObject sourceObject = source.getSourceObject(game);
                String exileName = sourceObject == null ? null : sourceObject.getIdName();
                card.setFaceDown(true, game);
                controller.moveCardsToExile(card, source, game, false, exileId, exileName);
                if (game.getState().getZone(card.getId()) == Zone.EXILED) {
                    card.setFaceDown(true, game);
                    JacobHaukenInspectorLookEffect effect = new JacobHaukenInspectorLookEffect(controller.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
        }
        return true;
    }
}

