/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.StackObject;

class JadedResponseEffect
extends OneShotEffect {
    JadedResponseEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell if it shares a color with a creature you control";
    }

    private JadedResponseEffect(JadedResponseEffect effect) {
        super((OneShotEffect)effect);
    }

    public JadedResponseEffect copy() {
        return new JadedResponseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        if (stackObject == null) {
            return false;
        }
        boolean matches = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).stream().map(permanent -> permanent.getColor(game)).anyMatch(arg_0 -> ((ObjectColor)stackObject.getColor(game)).shares(arg_0));
        return matches && game.getStack().counter(stackObject.getId(), source, game);
    }
}

