/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CreaturesAttackingYouCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class JaheirasRespiteEffect
extends OneShotEffect {
    JaheirasRespiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X basic land cards, where X is the number of creatures attacking you, put those cards onto the battlefield tapped, then shuffle";
    }

    private JaheirasRespiteEffect(JaheirasRespiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaheirasRespiteEffect copy() {
        return new JaheirasRespiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = CreaturesAttackingYouCount.instance.calculate(game, source, (Effect)this);
        if (count == 0) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, count, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LANDS);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        target.getTargets().stream().map(cardId -> player.getLibrary().getCard(cardId, game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        player.shuffleLibrary(source, game);
        return true;
    }
}

