/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class JailbreakEffect
extends OneShotEffect {
    JailbreakEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return target permanent card in an opponent's graveyard to the battlefield under their control. When that permanent enters the battlefield, return up to one target permanent card with equal or lesser mana value from your graveyard to the battlefield.";
    }

    private JailbreakEffect(JailbreakEffect effect) {
        super((OneShotEffect)effect);
    }

    public JailbreakEffect copy() {
        return new JailbreakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        if (card == null) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (!player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null)) {
            return false;
        }
        FilterPermanentCard filter = new FilterPermanentCard("permanent card with equal or lesser mana value from your graveyard");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, card.getManaValue() + 1));
        ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(), false, "When that permanent enters the battlefield, return up to one target permanent card with equal or lesser mana value from your graveyard to the battlefield.");
        reflexive.addTarget((Target)new TargetCardInYourGraveyard(0, 1, (FilterCard)filter));
        game.fireReflexiveTriggeredAbility(reflexive, source);
        return true;
    }
}

